function Rx = RotAXXB( Ra,Rb,method)
%Solves the system Ra*Rx=Rx*Rb for Rx
% 
% Copyright (C) Russell H. Taylor 2013
% For use with CIS I only
% Do not redistribute without written permission from Russell Taylor

meth = 'Quat';
% meth = 'Axis';
if nargin > 2
    meth = method;
end

switch meth
    case 'Quat'
        Rx = QuatRotAXXB(Ra,Rb);

    otherwise

        N = size(Ra,1);
        A = vct3Array(N-1);
        B = vct3Array(N-1);

        for i=1:N
            qa = quaternion(Ra(i));
            qb = quaternion(Rb(i));
            A(i) = qa.VectorPart()*qa.RealPart();
            B(i) = qb.VectorPart()*qb.RealPart();           
        end
        Rx = FindBestRigidRotation(B,A);
end
end



